function projData = Ax_partial(volData, cfg, vectors, split)
% recompile commands
%  (Linux)   mexcuda -largeArrayDims -v    ASTRA_GPU_wrapper/ASTRA_GPU_wrapper.cu ASTRA_GPU_wrapper/util3d.cu ASTRA_GPU_wrapper/par3d_fp.cu ASTRA_GPU_wrapper/par3d_bp.cu
%  (Windows)  mexcuda -largeArrayDims -v    ASTRA_GPU_wrapper\ASTRA_GPU_wrapper.cu ASTRA_GPU_wrapper\util3d.cu ASTRA_GPU_wrapper\par3d_fp.cu ASTRA_GPU_wrapper\par3d_bp.cu

%% forward projector that allows to split the full volume into smaller pieces
% volData - array Nx x Ny x Nz of projected volume 
% cfg - config structure generated by ASTRA_initialize
% vectors - orientation of projections generated by ASTRA_initialize
% split  3 or 4 elements vector, [split X, split Y, split Z, split angle ]

    
    
       
    if ismatrix(volData)
        split = split([1, min(2,end)]);
        assert(all(size(volData)==[cfg.iVolX,cfg.iVolY]), 'Wrong inputs size')
    else
        assert(all(size(volData)==[cfg.iVolX,cfg.iVolY,cfg.iVolZ]), 'Wrong inputs size')
    end

    %% backprojector that allows to split the full volume into smaller pieces
%     assert(all(mod(split,2)==1), 'Split should be odd number')
    assert(all(size(vectors)==[cfg.iProjAngles,12]), 'Wrong vectors size')
    
    split_projections = cfg.iProjAngles > 1024 || length(split) > 3;  % split contains also angular split 
    

    if all(split == 1) && ~split_projections
        if numel(volData)*4 > 1024e6
            nsubVol = ceil(numel(volData)*4 / 1024e6); 
            nsubVol = 2^nextpow2(nsubVol);
%             split = ceil([sqrt(nsubVol),sqrt(nsubVol),1]);
            split = [1,1,nsubVol];
            disp(['Volume array is larger than 1024MB, auto-splitting ', num2str(split)])
        else
            projData = ASTRA_GPU_wrapper('fp', gpuArray(single(volData)), cfg, vectors);
            projData = astra2matlab(projData);
            return
        end
    end
    if isscalar(split)
        split = split .* ones(ndims(volData),1);
    end
    assert(numel(volData)*4/prod(split) < 1024e6, 'Volume array exceeded 1024MB, use more splitting')

    Nvol_sub = size(volData)./split(1:3);
    
    assert(all(mod(Nvol_sub,1)==0), 'Volume cannot be splitted ')

    
    

    if ismatrix(volData)
        split(3) = 1;
        Nvol_sub(3) = 1;
    end

    gpu  = gpuDevice;
    fprintf('Free GPU memory: %3.2g%%\n',  gpu.AvailableMemory/gpu.TotalMemory*100)
    cfg.iVolX = cfg.iVolX/split(1);
    cfg.iVolY = cfg.iVolY/split(2);
    cfg.iVolZ = cfg.iVolZ/split(3);
    
    keep_on_GPU =  isa(volData, 'gpuArray');

    
    if split_projections
        %% fix if the number of projections is > 1024 (or it can be fixed in the ASTRA code )
        Nproj_groups  = ceil(cfg.iProjAngles/1024);
        if length(split) > 3 
            Nproj_groups = max(split(4), Nproj_groups);
        end
        for i = 1:Nproj_groups
            ind = (1+(i-1)*ceil(cfg.iProjAngles/Nproj_groups)):i*ceil(cfg.iProjAngles/Nproj_groups);
            ind = ind(ind <= cfg.iProjAngles);  
            vectors_tmp{i} = vectors(ind,:);
            cfg_tmp{i} = cfg;
            cfg_tmp{i}.iProjAngles = length(ind);
        end
        cfg = cfg_tmp; vectors = vectors_tmp;
    else
        Nproj_groups = 1;
        cfg = {cfg};
        vectors = {vectors};
    end
    clear ind 
    
%     keyboard
    
%     fprintf('Size of the full volume: %i %i %i\n', size(volData))
%     fprintf('Size of the subvolume: %i %i %i\n', Nvol_sub)
%     fprintf('Size of the one sinogram block: %i %i %i\n', cfg{1}.iProjU, cfg{1}.iProjV,  cfg{1}.iProjAngles)

    %%!!!! note that in rare cases astra my fail if sinogram width is too small 
    
    assert(prod(Nvol_sub) * 4 < 1024e6, 'Volume exceeded maximal size of texture 1024MB')


    
    iter = 0;
    for m = 1:Nproj_groups
        % split angularly (solve smaller groups of angles)
        if keep_on_GPU
            projData{m} = gpuArray.zeros(cfg{m}.iProjU, cfg{m}.iProjV, cfg{m}.iProjAngles, 'single');
        else
            projData{m} = zeros(cfg{m}.iProjU, cfg{m}.iProjV, cfg{m}.iProjAngles, 'single');
        end
        % split into volume cubes 
        for i = 1:split(1)
            for j =  1:split(2)
                for k = 1:split(3)
                    pos = [i,j,k];
%                     keyboard
                     for n = 1:3
                        ind{n} = (1+(pos(n)-1)*Nvol_sub(n)):(pos(n)*Nvol_sub(n));
                        %% find optimal shift of the subvolume
                        if mod(split(n),2)==1  %% odd 
                            shift(n) = (pos(n) - ceil(split(n)/2))*Nvol_sub(n);
                        else
                            shift(n) = (pos(n) - ceil(split(n)/2)-1/2)*Nvol_sub(n);
                        end
                     end

                    vol_small = volData(ind{:});  % take only small subvolume
                    vec = vectors{m};
                    vec(:,4:6) = bsxfun(@minus, vec(:,4:6), shift);
                    if keep_on_GPU
                        projData{m} = projData{m} +  ASTRA_GPU_wrapper('fp', vol_small, cfg{m}, vec);
                    else
                        vol_small = gpuArray(single(vol_small));
                        proj = ASTRA_GPU_wrapper('fp',vol_small, cfg{m}, vec);
                        projData{m} = projData{m} + gather(proj);
                        clear vol_small proj 
                    end
                    iter = iter+1;
                    progressbar(iter, prod(split)*Nproj_groups, 20);
                end
            end
        end
    end
    clear  volData vol
    if Nproj_groups > 1
        % permute / concatenate 
        for i = 1:Nproj_groups
            projData{i} =  astra2matlab(projData{i});
        end       
        % concatenate the projected data aling the angular (3rd) axis 
        projData = cat(3, projData{:});
    else        
        projData = astra2matlab(projData{1});
    end
    
    
    
end

