clear; close all; clc

import utils.*
addpath ../
addpath ../ptycho/
addpath ../ptycho/utils/

%%%%%%%%%%%%%%%%
% 0) Specify "scans", make sure scans(1) is the first scan of the tomo
%
% 1) Set flag_test = 1 to plot the output to check the auto-mask paramters
% are good. Select a good range for unwrapping (ry), which will be used in
% tomo_with_postprocess*.m.
% Can also set flag_unwrap = 1 to check if the time for unwrapping 
% is reasonable. If not, reduce the range (ry).
%
% 2) Set flag_test = 0 and run the script. Make sure flag_unwrap = 1.
%%%%%%%%%%%%%%%%
flag_test = 0; % test: plot output to check, no saving, no unwrap 

%%
flag_plot = flag_test;
save_output = ~flag_test;

flag_remove_ramp = 1;
flag_unwrap = ~flag_test;

%% Input
% Make sure scans(1) is the first scan and it is also the first scan 
% in tomo_with_postprocess*.m (because unwrapped objects are made the same
% with the object size of scans(1))
scans = [2152:2912];%[9:1390];
asize = [400 400];
base_path = '~/Data10/';     
omny_scan_file_search = [];  % (Not tested, better not use) ['~/Data10/specES1/ptycho_reconstruct/postprocess/']; % Folder where the queue of files is defined, note the content of files can overwrite some parameters
prefix = [];                                               
sufix = []; % do not include the _c 

auto_alignment = 0;
get_auto_calibration = 0;
obnum = 1;

%%%%%%%%%% Tweak automask parameters %%%%%%%%%%
smoothing = 30;     % Size of smoothing window
gradientrange = 4;  % Range of the phase gradient taken. In units of histogram bins
close_size = 15;    % Size of closing window, removes dark bubbles from the mask ( = 1 for no effect)
open_size = 150;    % Size of opening window, removes bright bubbles from mask ( = 1 for no effect)
maskzero_columnrange = [400:1100];  % Columns to be forced so the mask is zero. e.g. = [200:500], could be useful for middle of cylinders

show_bivariate = 0;     % Show the gradient bivariate histogram, input figure here
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
p.scan_number = scans(1);
files_recons = dir([omny_scan_file_search 'scan*']);
run_name = find_ptycho_filename(base_path,p.scan_number,prefix,sufix);
x = load(run_name);
dims_ob=size(x.object);
nx=dims_ob(2);
ny=dims_ob(1);

%%%%%%%%%% Choose well-behaved area for phase unwrapping %%%%%%%%%%
% No residues is very fast
% Lots of residues is madness and can fail
% This needs to be larger than the area you like to align afterwards
%
deltax = asize(1)/2+20;           % From edge of region to edge of image in x
ry  = [asize(1)/2-50:size(x.object,1)-asize(1)/2+50];        % Range in y
pixel = [deltax+5,ry(end)-5];
                        % Make sure its air in ALL projections
baraxis = 'auto';       % = 'auto'  or   = [-1 1]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
% if 1
while 1==1 
    for idx = 1:length(scans)
        tic
        p.scan_number = scans(idx);
        fprintf('-----\n');

        % ----- If gonna move .dat files around
        if (~isempty(omny_scan_file_search))
            verbose(1,['omny_scan_file_search is active, touching folder and looking for files in the queue in ' p.omny_scan_file_search]);
            [status, result] = system(['touch ' omny_scan_file_search '.'], '-echo');
            files_recons = dir([omny_scan_file_search 'scan*']);
            % Found one file to reconstruct
            if ~isempty(files_recons)
                file_this_recons = fullfile(omny_scan_file_search,files_recons(end).name);
                verbose(1,['Found file in queue ' file_this_recons]);        
                p = ptycho_parse_omny_dat(file_this_recons,p);

                % Now move this file to another folder
                if ~exist(fullfile(omny_scan_file_search,'done_process'))
                    mkdir(fullfile(omny_scan_file_search,'done_process'));
                end
                movefile(file_this_recons,fullfile(omny_scan_file_search,'done_process'))
                verbose(1,['Moving file to ' fullfile(omny_scan_file_search,'done_process')]);
            else
                verbose(1,'Did not find any file in queue, pausing 10 seconds and then exiting')
                out = p;
                pause(10)
                return
            end
        end
        
        % ---- Load file
        run_name = find_ptycho_filename(base_path,p.scan_number,prefix,sufix);
        if ~isempty(run_name)
            [file_path file_name file_extension] = fileparts(run_name);
            fn_out   = fullfile(file_path, [file_name '_unwrapped.mat']);
        else
            fn_out = [];
        end
        x = [];
        if exist(run_name)
            if exist(fn_out) 
                fprintf('Already have %s \n', fn_out);
                continue;
            else
                try
                    fprintf('Loading %s \n', run_name);
                    x = load(run_name);
                catch
                    continue;
                end
            end
        else
            fprintf('Cannot find reconstruction of scan %d \n', p.scan_number);
            display(['Wait for next round'])
            continue;
         end
        object = x.object;
        probe = x.probe;
%         error_metric = x.error_metric;
        dx_spec = x.p.dx_spec;
  
        ii = p.scan_number;

        % ---- Trim object size
        if size(object,2) > nx       
            object = object(:,1:nx);       
        elseif size(object,2) < nx
            object = padarray(object,[0 nx-size(object,2)],'post');
        end
        if size(object,1) > ny
            if auto_alignment||get_auto_calibration
                object = object(1:ny,:);
            else
                shifty = floor((size(object,1)-ny)/2);
                object = object([1:ny]+shifty,:);
            end
        elseif size(object,1) < ny
            if auto_alignment||get_auto_calibration
                object = padarray(object,[ny-size(object,1) 0],'post');
            else
                shifty = (ny-size(object,1))/2;
                object = padarray(object,[ny-size(object,1)-floor(shifty) 0],'post');
                object = padarray(object,[floor(shifty) 0],'pre');
            end
        end
        object_size = size(object);
        %fprintf('object size [%d, %d] \n', object_size(1), object_size(2));
        
        % ---- Auto mask
        %mask1 = auto_mask_find(object,'margin',size(probe)/2,'smoothing',smoothing,...
        %'gradientrange',gradientrange,'close_size',close_size,'open_size',open_size,'show_bivariate',show_bivariate,'zero_columns',maskzero_columnrange);
        %close all
        mask1 = auto_mask_find(object,'margin',size(probe)/2,'smoothing',smoothing,...
        'gradientrange',gradientrange,'close_size',close_size,'open_size',open_size,'show_bivariate',show_bivariate,'zero_columns',maskzero_columnrange);
        close all

        if flag_plot
            figure(100);
            subplot(2,2,1);
            imagesc(angle(object).*mask1);
            axis xy equal tight
            colormap bone
            title('auto mask');
        end

        % ---- Remove ramp
        if flag_remove_ramp
            display(['Removing phase ramp'])
            [object ph_err] = remove_linear_phase_smart(object,'mask',mask1);
        end

        object_phase = angle(object);

        if flag_plot
            subplot(2,2,2);
            absob = angle(object);
            imagesc(([1 object_size(obnum,2)]-floor(object_size(obnum,2)/2)+1)*dx_spec(2)*1e6,([1 object_size(obnum,1)]-floor(object_size(obnum,1)/2)+1)*dx_spec(1)*1e6,absob);
            axis xy equal tight
            colormap bone

            subplot(2,2,[3 4]);
            line_mid = floor(size(object,1)/2);
            plot(angle(object(line_mid,:))); grid on;
            title(sprintf('Line %d profile',line_mid))

            xlabel('\mum')
            ylabel('\mum')

            set(gca,'fontsize',15,'fontweight','bold');
            
            return
        end
        
        % ---- Find and plot residues
        display(['Searching for residues in ' num2str(ii)])
        residues = abs(findresidues(object_phase));

        % ---- Unwrap
        rx=[1+deltax:size(object,2)-deltax];
        if (pixel(1)<rx(1))|(pixel(1)>rx(end))|(pixel(2)<ry(1))|(pixel(2)>ry(end))
            error('Pixel of air is outside of region of unwrapping')
        end
        display(['Chosen region contains ' num2str(round(sum(sum(residues(ry,rx))))) ' residues in total'])
        if flag_plot
            imagesc(angle(object)); colormap bone(256); hold on;
            set(gcf,'Outerposition',[141 257 1060 767]);
            plot([rx(1),rx(end)],[ry(1),ry(1)],'r');
            plot([rx(1),rx(end)],[ry(end),ry(end)],'r');
            plot([rx(1),rx(1)],[ry(1),ry(end)],'r');
            plot([rx(end),rx(end)],[ry(1),ry(end)],'r');
            plot(pixel(1), pixel(2),'or')
            hold off;
            axis xy equal tight; 
            title(sprintf('projection %03d',ii))
            drawnow;
        end

        if flag_unwrap
            display(['Unwrapping projection ' num2str(ii)])
            % this_img=squeeze(stack_phase_corr(:,:,ii));
            % sel=this_img(ry,rx);
            sel = object_phase(ry,rx);
            %sel_unwrap=unwrap(sel,[],2);  % Matlab's routine, fast but problematic
            %with noise
            sel_unwrap=goldsteinunwrap2(sel,0);  % Goldstein's method, very robust (gets slow if there are residues)
            img_unwrap=object_phase;
            img_unwrap(ry,rx)=sel_unwrap;
            img_unwrap(ry,rx) = img_unwrap(ry,rx) - 2*pi*round(img_unwrap(pixel(2),pixel(1))/(2*pi));
            %stack_unwrap(:,:,idx)=img_unwrap;

            if flag_plot
                imagesc(img_unwrap); colormap bone(256); hold on;
                set(gcf,'Outerposition',[141 257 1060 767]);
                plot([rx(1),rx(end)],[ry(1),ry(1)],'r');
                plot([rx(1),rx(end)],[ry(end),ry(end)],'r');
                plot([rx(1),rx(1)],[ry(1),ry(end)],'r');
                plot([rx(end),rx(end)],[ry(1),ry(end)],'r');
                plot(pixel(1), pixel(2),'or')
                hold off;
                axis xy equal tight; 
                title(sprintf('projection %03d',ii))
                drawnow;
            end
        end

        % ---- Save
        if save_output && flag_unwrap
            param.smoothing = smoothing;
            param.gradientrange = gradientrange;
            param.close_size = close_size;
            param.open_size = open_size;
            param.maskzero_columnrange = maskzero_columnrange;
            param.deltax = deltax;
            param.ry = ry;
            param.rx = rx;
            param.pixel = pixel;
            param.scans = scans;
            p = x.p;
            object = x.object;
            object_phase_unwrap = img_unwrap;

            save(fn_out,'object','p','param','mask1','object_phase_unwrap');
            fprintf('Saved to %s \n',fn_out);
        end
        toc
    end
    display('Pause for 5 minutes before going through the for loop again.')
    pause(60*5);
end


