%% Template for tomographic reconstruction from stxm data
addpath('../')
addpath('../ptycho')
import io.spec_read
import utils.*
return
%% Read stxm files
%%%% Physical values %%%%
lambda  = 0.2e-9;
pixsize = 1e-6;
detpix  = 172e-6;
detdist = 7.325;
%%%%%%%%%%%%%%%%%%%%%%%%%

base_path=['~/Data10']
lines=101;
numOfprojection = 91;
firstscan_num = 1090;
output_folder=[base_path sprintf('/analysis/tomo_stxm_%05d_%05d/',firstscan_num,firstscan_num+lines*numOfprojection)];
output_name=sprintf('stxm_%05d_%05d',firstscan_num,firstscan_num+lines*numOfprojection);
for ii = 1:numOfprojection
    firstscan=firstscan_num+lines*(ii-1);
    lastscan  = firstscan+lines-1;
    %filename = ['~/Data10/analysis/online/stxm/data/stxm_scans_1_' sprintf('%05d',firstscan) '-'  sprintf('%05d',lastscan) '.mat'];
    filename = [base_path sprintf('/analysis/online/stxm/data/stxm_scans_1_%05d-%05d.mat', firstscan, lastscan)];
    projection(ii) = load(filename);
    tosee = projection(ii).dpcx;
    %tosee = projection(ii).dpcy;
    %tosee = projection(ii).df;
    %tosee = projection(ii).trans;
    stackdpcx(:,:,ii) = projection(ii).dpcx';
    stackdpcy(:,:,ii) = projection(ii).dpcy';
    stackdf(:,:,ii) = projection(ii).df';
    stacktrans(:,:,ii) = projection(ii).trans';
    
    figure(1);
    imagesc(tosee)
    axis xy equal tight
    colormap bone
    title(['Scan ' num2str(firstscan) '-' num2str(lastscan)])
    colorbar
    drawnow
    pause(0.3)
    
  
    
end
%% See stack

for ii = 1:size(stackdpcx,3)
    figure(12);
    imagesc(stackdpcy(:,:,ii))
    axis xy equal tight
    colormap bone
    title(['Scan ' num2str(firstscan) '-' num2str(lastscan)])
    colorbar
    drawnow
    pause(0.1)
    
    if any(any(isnan(stackdpcx(:,:,ii))))
        display([num2str(ii)])
    end
end
%% Arrange stack
for ii = 1:numOfprojection
    firstscan=firstscan_num+lines*(ii-1);
    lastscan  = firstscan+lines-1;
    spec_data = spec_read('~/Data10/','ScanNr',firstscan);
    theta(ii)=spec_data.samroy;
end
figure(1)
subplot(2,1,1)
plot(theta)
subplot(2,1,2)
plot(diff(sort(theta)));

%% Alignment in y
%% REGISTRATION - DERIVATIVE MASS REGISTRATION IN Y

disp = 2;       % = 0 no display, =1 only final display, >1 every iteration
pixtol = 1;   % Tolerance of registration in pixels
rembias = true; % Remove bias for y registration
maxorder = 0;   % Max order of bias to remove
paramsalign.alignx = false;  % Align in x
paramsalign.expshift = false;% Shift in phasor space
paramsalign.interpmeth = 'linear'; % Subpixel interpolation method

limsy = [4 size(stackdpcy,1)-4]; % Window inside regstack used for alignment                    
delta = 0; % Window should be centered in x to ensure compliance with iradonfast
limsx = [1+delta size(stackdpcy,2)-delta];

figure(1)
clf
deltastackglobal = zeros(2,size(stackdpcy,3));
%deltastackglobal(1,:) = 3*rand(1,size(stackdpcy2,3));
% deltastack(1,153:157) = -5;
% deltastack(1,:) = deltastack(1,:) - mean(deltastack(1,:));

[deltastackglobal stackdpcy_aligned] = alignprojections_v4(stackdpcy,limsy,limsx,deltastackglobal,pixtol,rembias,maxorder,disp,paramsalign);
%deltastackglobal(1,[10 39 42]) = 1;
%[deltastackglobal stackdpcy_aligned] = alignprojections_v4(stackdpcy,limsy,limsx,deltastackglobal,pixtol,rembias,maxorder,disp,paramsalign);
%% See stackdpcy3

for ii = 1:size(stackdpcy_aligned,3)
    figure(12);
    imagesc(stackdpcy_aligned(:,:,ii))
    axis xy equal tight
    colormap bone
    title(['Scan ' num2str(firstscan) '-' num2str(lastscan)])
    colorbar
    drawnow
    pause(0.1)
    
 
end

%% Apply the shifts to DPCX (Realign DPCX)
stackdpcx_aligned = stackdpcx*0;
for ii = 1:size(stackdpcx_aligned,3)
    stackdpcx_aligned(:,:,ii) = shiftwrapbilinear(stackdpcx(:,:,ii),deltastackglobal(1,ii),0);
    display([num2str(ii)])
end

%% See stackdpcx_aligned

for ii = 1:size(stackdpcx_aligned,3)
    figure(12);
    imagesc(stackdpcx_aligned(:,:,ii))
    axis xy equal tight
    colormap bone
    title(['Scan ' num2str(firstscan) '-' num2str(lastscan)])
    colorbar
    drawnow
    %pause(0.1)
    
 
end


%% Select mask for offset removal
mask = stackdpcx_aligned(:,:,1)*0;
mask(1:end,1+5:end-5) = 1;
for ii = 1:size(stackdpcx_aligned,3)
    aux = stackdpcx_aligned(:,:,ii);
    stackdpcx_offset(:,:,ii) = stackdpcx_aligned(:,:,ii)-mean(mean(aux(mask==1)));
    figure(12);
    %imagesc(stackdpcx_offset(:,:,ii).*mask)
    imagesc(stackdpcx_offset(:,:,ii))
    axis xy equal tight
    colormap bone
    title(['Scan ' num2str(firstscan) '-' num2str(lastscan)])
    colorbar
    caxis([-0.5 0.5])
    drawnow
    pause(0.1)
    
 
end
%% Align in x direction - 1 slice
freq_scale = 1;
pixtol = 0.01;
disp = 2;
paramsalign.expshift = false;
paramsalign.interpmeth = 'sinc';  % 'sinc' or 'linear'
paramsalign.filtertomo = 0.4;         % frequency cutoff
paramsalign.usecircle = true;
% paramsalign.cliplow       Minimum value in tomogram
paramsalign.cliphigh = -0.01; % Maximum value in tomogram

x_offset = -1;
ii = 40; % slice to align
sinogramder = double(squeeze(stackdpcx_offset(ii,:,:)));
deltaslice = zeros(1,size(sinogramder,2))+x_offset;
[deltaslice alignedslice] =  alignslice_filt_v2(sinogramder,theta+0.2,deltaslice,pixtol,disp,paramsalign);
%[deltaslice alignedslice] =  alignslice_filt_v2(sinogramder,theta+0.2,deltaslice,pixtol,disp,paramsalign);

    
tomodpcx(:,:,ii) = iradonfast_v2(alignedslice,...
    theta,'linear','derivative','Ram-Lak',size(alignedslice,1),freq_scale);

figure(1);
imagesc(alignedslice)

figure(4);
imagesc(-tomodpcx(:,:,ii))
axis equal tight
colormap bone
colorbar
caxis([-1 0.2])
caxis([-0.2 1])
title([num2str(ii)])
%end
%% Align in x direction - multiple slices
cuales = [ii-5:ii+5];
for ii = cuales;
    sinogramder = double(squeeze(stackdpcx_offset(ii,:,:)));
    [deltaaux alignedslice] =  alignslice_filt_v2(sinogramder,theta+0.2,deltaslice,pixtol,disp,paramsalign);
    deltaslices(ii,:) = deltaaux;
    display([num2str(ii)])
end
%% See displacements, check for consistency
figure(2);
imagesc(deltaslices)

deltaslice2 = mean(deltaslices(cuales,:));


%% Shift images by deltaslice2

interpmeth = 'linear';
stackdpcx_xshifted = stackdpcx_offset*0;
for ii = 1:size(stackdpcx_xshifted,3),
    switch interpmeth
        case 'sinc'
            stackdpcx_xshifted(:,:,ii) = shiftpp2(stackdpcx_offset(:,:,ii),0,deltaslice2(1,ii));
        case 'linear'
            stackdpcx_xshifted(:,:,ii) = shiftwrapbilinear(stackdpcx_offset(:,:,ii),0,deltaslice2(1,ii));
    end
    if mod(ii,20) == 0,
        display(['Image ' num2str(ii) ' of ' num2str(size(stackdpcx_offset,3))]),
    end
end
%% Apply shifts to amplitude projections
stacktrans_xshifted = stacktrans*0;
stackdf_xshifted = stackdf*0;
for ii = 1:size(stacktrans_xshifted,3),
    switch interpmeth
        case 'sinc'
            stacktrans_xshifted(:,:,ii) = shiftpp2(stacktrans(:,:,ii),deltastackglobal(1,ii),deltaslice2(1,ii));
            stackdf_xshifted(:,:,ii) = shiftpp2(stackdf(:,:,ii),deltastackglobal(1,ii),deltaslice2(1,ii));
        case 'linear'
            stacktrans_xshifted(:,:,ii) = shiftwrapbilinear(stacktrans(:,:,ii),deltastackglobal(1,ii),deltaslice2(1,ii));
            stackdf_xshifted(:,:,ii) = shiftwrapbilinear(stackdf(:,:,ii),deltastackglobal(1,ii),deltaslice2(1,ii));
    end
    if mod(ii,20) == 0,
        display(['Image ' num2str(ii) ' of ' num2str(size(stacktrans,3))]),
    end
end
    

%% Clip up-down (preferably symmetric)
cliplimsy = [2:size(stackdpcx_offset,1)-2];
stackdpcx_yclipped  = stackdpcx_xshifted(cliplimsy,:,:);
stacktrans_yclipped = stacktrans_xshifted(cliplimsy,:,:);
stackdf_yclipped    = stackdf_xshifted(cliplimsy,:,:);
%% The real Tomography - after alignement
freq_scale = 1;
tomodpcx = zeros(size(stackdpcx_yclipped,2),size(stackdpcx_yclipped,2),size(stackdpcx_yclipped,1));
tomotrans = tomodpcx*0;
tomodf = tomodpcx*0;
offsetval = 0;
xoffset = 0;

for ii = 1:size(stackdpcx_yclipped,1)
    sino = squeeze(stackdpcx_yclipped(ii,:,:));
    sino = sino-offsetval;
    sino = shiftpp2(sino,xoffset,0);
    tomodpcx(:,:,ii) = iradonfast_v2(sino,theta,'linear','derivative','Ram-Lak',size(sino,1),freq_scale);
    
    sinotrans = squeeze(stacktrans_yclipped(ii,:,:));
    sinotrans = sinotrans-offsetval;
    sinotrans = shiftpp2(sinotrans,xoffset,0);
    sinotrans = shiftpp2(sinotrans,0.5,0)-shiftpp2(sinotrans,-0.5,0);
%     sinotrans(1:end-1,:) = diff(sinotrans);
    sinotrans(1,:) = 0;
    sinotrans(end,:) = 0;
    tomotrans(:,:,ii) = iradonfast_v2(sinotrans,theta,'derivative','linear','Ram-Lak',size(sinotrans,1),freq_scale);

    sinodf = squeeze(stackdf_yclipped(ii,:,:));
    sinodf = sinodf-offsetval;
    sinodf = shiftpp2(sinodf,xoffset,0);
    sinodf = shiftpp2(sinodf,0.5,0)-shiftpp2(sinodf,-0.5,0);
%     sinotrans(1:end-1,:) = diff(sinotrans);
    sinodf(1,:) = 0;
    sinodf(end,:) = 0;
    tomodf(:,:,ii) = iradonfast_v2(sinodf,theta,'derivative','linear','Ram-Lak',size(sinodf,1),freq_scale);

    
    figure(1); 
%     imagesc(sino)
    imagesc(sinodf)

    figure(5); 
%     imagesc(-tomodpcx(:,:,ii))
%     imagesc(tomotrans(:,:,ii))
    imagesc(tomodf(:,:,ii))
    axis equal tight
    colormap bone
    colorbar
    %caxis([-1 0.2])
%     caxis([-0.1 0.8])
    title([num2str(ii)])
end



%% Display reconstructed volume by slices
%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Edit this section %%%
%%%%%%%%%%%%%%%%%%%%%%%%%
displaytomo = 'phase';       % 'phase', 'amp', 'darkfield'
displayaxis = 2;            % 1 coronal, 2 sagital, 3 axial
displayslice = [42];         % Many slices supported e.g [100:200]. If left empty the center slice is shown, 
animatedslices = 0;     % All slices are shown ignoring those in displayslice
% Display options
tomobaraxis = 'auto';%[0.2 0.4];%       % = 'auto'  or e.g.  = [-1 1]. For auto it picks max and min from whole tomogram
scale = 'edensity';            % = 'phase', 'delta' [index] or 'edensity' [electron/A^3]'
colormapchoice = 'bone';    % Choose the colormap
realaxis = 1;            % = true to show result with real axes units, = false for pixels
reverse_contrast = 1;    % Reverse grayscale
% Scale bar options (only shown if realaxis = true)
bar_length= 10e-6;           % Lenght of scalebar (only used if realaxis = true)
bar_height= 1e-6;           % Height of scalebar (only used if realaxis = true)
bar_start_point=[2 2]*1e-6;    % (x, y) starting point of the scale bar (from corner) in meters
bar_color = 'w';            % Color of scalebar
% Other
windowautopos = true;      % If true the window position and size is changed, can be useful as false when ready to render a movie
makemovie = false;          % = true for rendering an AVI
writesnapshots = false;      % Makes jpeg and eps snaphots. It overwrites snapshots. If many slices are chosen it writes only the last one.
pausetime = 0.1;            % Pause time for animation or multiple slices
%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%
scans_string=output_name;
factorphaseglobal = detpix*2*pi*pixsize/(lambda*detdist);
factor = lambda/(2*pi*pixsize);
factor_edensity = 1e-30*2*pi/(lambda^2*2.81794e-15);
% tomoextr = tomoextr*factorphase;
% Coronal, first index
% Sagital, second index
% Axial,   third index

switch lower(displaytomo)
    case 'phase'
        tomogram=tomodpcx*factorphaseglobal; % To go from pixel shifts on pilatus to phase per voxel
    case 'amp'
        tomogram=tomotrans;
    case 'darkfield'
        tomogram=tomodf;
    otherwise
        error('Unknown contrast requested, choose phase, amp, or darkfield')
end

if makemovie    % Open movie file
    output_name = sprintf('S%05d_S%05d',scanstomo(1),scanstomo(end));
    movie_filename = [output_folder output_name '_' filter_type '_freqscl_' sprintf('%0.2f',freq_scale) '_movie_axis_' sprintf('%01d',displayaxis) '.avi'];
    if exist(movie_filename,'file')
        display(['File ' movie_filename ' exists,' ])
        userans = input(['Do you want to overwrite (y/n)? '],'s');
        if strcmp(lower(userans),'y')
            display(['Saving movie to  ' movie_filename]);
            writeobj = VideoWriter(movie_filename); writeobj.Quality=50;writeobj.FrameRate=5; open(writeobj); 
        else
            display(['Did not save ' saveprojfile])
            break
        end
    else
        display(['Saving movie to  ' movie_filename]);
        writeobj = VideoWriter(movie_filename); writeobj.Quality=50;writeobj.FrameRate=5; open(writeobj); 
    end
end

% If displayslices is empty show central slice
if isempty(displayslice)&&(~animatedslices)
    display('Displaying central slice')
    displayslice = round(size(tomogram,displayaxis)/2);
end

% Determine range of tomogram
if isstr(tomobaraxis)&&strcmpi('auto',tomobaraxis)
    autobar = true;
    if ~reverse_contrast
        tomobaraxis = [min(tomogram(:)) max(tomogram(:))];
    else
        tomobaraxis = [-max(tomogram(:)) -min(tomogram(:))];
    end
else
    autobar = false;
end
switch lower(scale)
    case 'phase'
        strscale = 'phase';
    case 'delta'
        if autobar
            tomobaraxis = tomobaraxis*factor;
        end
        strscale = 'delta';
    case 'edensity'
        if autobar
            tomobaraxis = tomobaraxis*factor*factor_edensity;
        end
        strscale = 'electron density [e/A^3]';
    otherwise
        error('scale should be phase, delta or edensity')
end

%%% Here the option for showing animation
if animatedslices
    displayslice = [1:size(tomogram,displayaxis)];
end
for showslice = displayslice
    % Determine sagital, coronal or axial slices
    switch displayaxis
        case 1
            sliceview = squeeze(tomogram(showslice,:,:))';
            sectionstring = 'Coronal';
        case 2
            sliceview = squeeze(tomogram(:,showslice,:))';
            sectionstring = 'Sagital';
        case 3
            sliceview = squeeze(tomogram(:,:,showslice));
            sectionstring = 'Axial';
        otherwise
            error('Unexpected choice of displayaxis')
    end
    
    if reverse_contrast
        sliceview = -sliceview;
    end
    
    switch lower(scale)
        case 'phase'
        case 'delta'
            sliceview = sliceview*factor;
        case 'edensity'
            sliceview = sliceview*factor*factor_edensity;
        otherwise
            error('scale should be phase, delta or edensity')
    end
    
    figure(1)
    if windowautopos
        set(gcf,'Outerposition',[1 359 640 665]);
        windowautopos = false;
    end
    if ~realaxis
        imagesc(sliceview)
    else
        xaux = ([1 size(sliceview,2)]-size(sliceview,2)/2)*pixsize*1e6;
        yaux = ([1 size(sliceview,1)]-size(sliceview,1)/2)*pixsize*1e6;
        imagesc(xaux,yaux,sliceview)
        xlabel('microns')
        ylabel('microns')
    end
    if (~isempty(bar_length))&&realaxis  %% Show scale bar
        hold on
        axisaux = axis;  
        rectangle('Position', [axisaux(1)+bar_start_point(1)*1e6 axisaux(3)+bar_start_point(2)*1e6 bar_length*1e6 bar_height*1e6],'facecolor',bar_color,'edgecolor','none') 
        text(axisaux(1)+bar_start_point(1)*1e6,...
            axisaux(3)+bar_start_point(2)*1e6+bar_height*2e6,...
            [num2str(bar_length*1e6) ' microns'],'Color',bar_color,'FontSize',12);
        hold off
    end
    title(['Tomogram ' strscale ': ' strrep(scans_string, '_', '\_') ...
        ' ' sectionstring ' section: Slice ' num2str(showslice)])
    axis xy image
    colormap(colormapchoice)
    caxis(tomobaraxis)
    colorbar
    drawnow
    if makemovie
        currFrame = getframe;
        writeVideo(writeobj,currFrame);
    end
    pause(pausetime)
    
end

if makemovie == 1 
    close(writeobj); 
end

if writesnapshots
    output_snapshot_name = sprintf('S%05d_S%05d',scanstomo(1),scanstomo(end));
    output_jpeg = [ output_folder output_snapshot_name '_' filter_type '_freqscl_' sprintf('%0.2f',freq_scale) '_axis_' num2str(displayaxis) '_slice_' num2str(showslice) '.jpg'];
    output_eps  = [ output_folder output_snapshot_name '_' filter_type '_freqscl_' sprintf('%0.2f',freq_scale) '_axis_' num2str(displayaxis) '_slice_' num2str(showslice) '.eps'];
    display(sprintf('Writting image files \n %s \n %s',output_jpeg,output_eps));
    print('-f1','-djpeg','-r300',output_jpeg);
    print('-f1','-depsc2',output_eps);
end

%% Save tomogram and relevant parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%
savedata = true;
%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%

if savedata == 1
    if ~exist('output_folder','dir'); mkdir(output_folder); end
    saveprojfile = [output_folder 'tomo_' output_name '_freqscl_' sprintf('%0.2f',freq_scale) '.mat'];
    if exist(saveprojfile,'file')
        display(['File ' saveprojfile ' exists,' ])
        userans = input(['Do you want to overwrite (y/n)? '],'s');
        if strcmp(lower(userans),'y')
            display(['Saving to  ' saveprojfile]);
            save(saveprojfile,'tomodpcx','tomotrans','tomodf','base_path','cliplimsy','cuales','deltaslice2','deltastackglobal','detdist','detpix','factor_edensity','factordeltaglobal','factorphaseglobal','filename','freq_scale','first_scan_num','lambda','lastscan','lines','numOfprojection','output_folder','output_name','pixsize','scans_string');
        else
            display(['Did not save ' saveprojfile])
        end
    else
        display(['Saving to  ' saveprojfile]);
            save(saveprojfile,'tomodpcx','tomotrans','tomodf','base_path','cliplimsy','cuales','deltaslice2','deltastackglobal','detdist','detpix','factor_edensity','factordeltaglobal','factorphaseglobal','filename','freq_scale','first_scan_num','lambda','lastscan','lines','numOfprojection','output_folder','output_name','pixsize','scans_string');
    end
end

%% See tomogram ROI S01090 - S10281
% % Note: Indices in reconstruction are according to usual approach of having
% % theta = samroy. This however results in mirrored images, which make ROIs
% % move a bit strange with samz and samx. However all is accounted for and
% % the shown region is the region to scan.
% hyglobal = -6.0590e-3;
% samx_hwglobal = -0.2706e-3;
% samz_hwglobal = 2.9993e-3;
% pixelglobal = 1e-6;
% 
% barra = [0.4 0.8];
% 
% drawarea1 = true;
% drawarea2 = false;
% 
% % area1x = [-12 12];
% % area1y = [-12 12];
% % area1xoffset = 42;
% % area1yoffset = 81;
% 
% % Global tomo 14022-14203
% hyarea1 = -6.0790e-3;
% samx_hwarea1 = -0.2687e-3;
% samz_hwarea1 = 2.9913e-3;
% area1x = [-30 30]*1e-6;
% area1y = [-5 5]*1e-6;
% 
% 
% % Computed quantities
% area1xoffset = samx_hwglobal-samx_hwarea1;
% area1zoffset = -samz_hwglobal+samz_hwarea1;
% area1yoffset = hyglobal-hyarea1;
% display('Difference between global and local scans')
% display(['hy_local - hy_global = ' num2str((hyarea1-hyglobal)*1e6) ' um'])
% display(['samx_hw_local - samx_hw_global = ' num2str((samx_hwarea1 -samx_hwglobal)*1e6) ' um'])
% display(['samz_hw_local - samz_hw_global = ' num2str((samz_hwarea1 -samz_hwglobal)*1e6) ' um'])
% 
% area2x = [-16 16];
% area2y = [-15 15];
% area2xoffset = 42;
% area2yoffset = 40;
% auxaxis = pixelglobal*([1:size(tomodpcx,1)]-ceil(size(tomodpcx,1)/2));
% auxvertaxis = pixelglobal*([1:size(tomodpcx,3)]-ceil(size(tomodpcx,3)/2));
% 
% for ii = ceil(size(tomodpcx,3)/2)+round(area1yoffset/pixelglobal)
% figure(2); 
%     imagesc(auxaxis/pixelglobal,auxaxis/pixelglobal,-tomodpcx(:,:,ii))
%     axis xy equal tight
%     colormap bone
%     colorbar
%     caxis(barra)
%     title(['Slice ' num2str(ii)])
%     xlabel('x [um]')
%     ylabel('z [um]')
%     if drawarea1
%         hold on
%         phiplot = [0:360]*pi/180;
%         plot(area1xoffset/pixelglobal+[(area1x(2)-area1x(1)).*cos(phiplot)/2]/pixelglobal,area1zoffset/pixelglobal+[(area1x(2)-area1x(1)).*sin(phiplot)/2]/pixelglobal,'Linewidth',2)
%         hold off,
%     end
%     if drawarea2
%         hold on
%         phiplot = [0:360]*pi/180;
%         plot(area2xoffset+[(area2x(2)-area2x(1)).*cos(phiplot)/2],area2xoffset+[(area2x(2)-area2x(1)).*sin(phiplot)/2],'r','Linewidth',2)
%         hold off,
%     end
%     drawnow
% end
% %
% for ii = ceil(size(tomodpcx,1)/2)+round(area1zoffset/pixelglobal)
% figure(3); 
%     imagesc(auxaxis/pixelglobal,auxvertaxis/pixelglobal,-squeeze(tomodpcx(ii,:,:))')
%     axis xy equal tight
%     colormap bone
%     colorbar
%     caxis(barra)
%     title(['Slice ' num2str(ii)])
%     xlabel('x [um]')
%     ylabel('y [um]')
%     if drawarea1
%         hold on
%         plot(area1xoffset*1e6+[area1x(1) area1x(1)]*1e6, area1yoffset*1e6+[area1y(1) area1y(2)]*1e6,'Linewidth',2)
%         plot(area1xoffset*1e6+[area1x(2) area1x(2)]*1e6, area1yoffset*1e6+[area1y(1) area1y(2)]*1e6,'Linewidth',2)
%         plot(area1xoffset*1e6+[area1x(1) area1x(2)]*1e6, area1yoffset*1e6+[area1y(1) area1y(1)]*1e6,'Linewidth',2)
%         plot(area1xoffset*1e6+[area1x(1) area1x(2)]*1e6, area1yoffset*1e6+[area1y(2) area1y(2)]*1e6,'Linewidth',2)
%         hold off,
%     end
%     if drawarea2
%         hold on
%         plot(area2xoffset+[area2x(1) area2x(1)], area2yoffset+[area2y(1) area2y(2)],'r','Linewidth',2)
%         plot(area2xoffset+[area2x(2) area2x(2)], area2yoffset+[area2y(1) area2y(2)],'r','Linewidth',2)
%         plot(area2xoffset+[area2x(1) area2x(2)], area2yoffset+[area2y(1) area2y(1)],'r','Linewidth',2)
%         plot(area2xoffset+[area2x(1) area2x(2)], area2yoffset+[area2y(2) area2y(2)],'r','Linewidth',2)
%         hold off,
%     end
%     drawnow
% end
% for ii = ceil(size(tomodpcx,1)/2)+round(area1xoffset/pixelglobal)
% figure(4); 
%     imagesc(auxaxis/pixelglobal,auxvertaxis/pixelglobal,-squeeze(tomodpcx(:,ii,:))')
%     axis xy equal tight
%     colormap bone
%     colorbar
%     caxis(barra)
%     title(['Slice ' num2str(ii)])
%     xlabel('z [um]')
%     ylabel('y [um]')
%     if drawarea1
%         hold on
%         plot(area1zoffset*1e6+[area1x(1) area1x(1)]*1e6, area1yoffset*1e6+[area1y(1) area1y(2)]*1e6,'Linewidth',2)
%         plot(area1zoffset*1e6+[area1x(2) area1x(2)]*1e6, area1yoffset*1e6+[area1y(1) area1y(2)]*1e6,'Linewidth',2)
%         plot(area1zoffset*1e6+[area1x(1) area1x(2)]*1e6, area1yoffset*1e6+[area1y(1) area1y(1)]*1e6,'Linewidth',2)
%         plot(area1zoffset*1e6+[area1x(1) area1x(2)]*1e6, area1yoffset*1e6+[area1y(2) area1y(2)]*1e6,'Linewidth',2)
%         hold off,
%     end
%     if drawarea2
%         hold on
%         plot(area2xoffset+[area2x(1) area2x(1)], area2yoffset+[area2y(1) area2y(2)],'r','Linewidth',2)
%         plot(area2xoffset+[area2x(2) area2x(2)], area2yoffset+[area2y(1) area2y(2)],'r','Linewidth',2)
%         plot(area2xoffset+[area2x(1) area2x(2)], area2yoffset+[area2y(1) area2y(1)],'r','Linewidth',2)
%         plot(area2xoffset+[area2x(1) area2x(2)], area2yoffset+[area2y(2) area2y(2)],'r','Linewidth',2)
%         hold off,
%     end
%     drawnow
% end



