addpath ~/Data10/cxs_software/base/
addpath ~/Data10/cxs_software/ptycho/


filename_history = '~/Data10/specES1/internal/sample_centering_history.txt';
if ~exist(filename_history,'file')
    fidh = fopen(filename_history,'a+');
    fprintf(fidh,'%s\t%s\t%s\t%s\n','scan','leftedge','rightedge','width');
    fclose(fidh);
end

prev_scan = 0;
while 1==1
    fdirs = dir('~/Data10/analysis/*/*/*recons.h5');
    
    filename = fullfile(fdirs(end).folder,fdirs(end).name);
    fprintf('Reading %s\n',filename);
    try
        [ob, pr, p] = io.load_ptycho_recons(filename);
    catch
        fprintf('Oh no... I was not able to read the reconstruction file. I will try again later\n')
    end
    %
    ob2  = ob(p.asize(1)/2:end-p.asize(1)/2,p.asize(2)/2:end-p.asize(2)/2);
    amp = abs(ob2);
    phasegrad = angle(ob2(1:end-1,1:end-1).*conj(ob2(2:end,2:end)));
    numslices = 4;
    N = floor(size(ob2,1)/numslices);
    ind(1) = size(ob2,2);
    ind(2) = 1;
    for ii = 0:numslices-1
        lineplot = sum(phasegrad(1+ii*N:N-1+ii*N,:),1);
        auxind(1) = find( lineplot == max(lineplot) );
        auxind(2) = find( lineplot == min(lineplot) );
        if auxind(1) < ind(1)
            ind(1) = auxind(1);
        end
        if auxind(2) > ind(2)
            ind(2) = auxind(2);
        end

    end
    
    
    
    x = [1:size(ob2,2)] - size(ob2,2)/2;
    y = [1:size(ob2,1)] - size(ob2,1)/2;
    x = x*p.dx_spec(2)*1e6;
    y = y*p.dx_spec(1)*1e6;
    
    fid = fopen('~/Data10/specES1/internal/sample_centering.txt','w+');
    
    fprintf(fid,'%s\t%s\t%s\n','scan','leftedge','rightedge');
    fprintf(fid,'%05d\t%f\t%f\n',p.scan_number(1),x(ind(1)),x(ind(2)));
    fclose(fid);
    
    if prev_scan == p.scan_number
        write_history = false;
    else
        write_history = true;
        prev_scan = p.scan_number;
    end
    
    if write_history
        fidh = fopen('~/Data10/specES1/internal/sample_centering_history.txt','a+');
        fprintf(fidh,'%05d\t%f\t%f\t%f\n',p.scan_number(1),x(ind(1)),x(ind(2)),x(ind(2))-x(ind(1)));
        fclose(fidh);
    end
    fprintf('Sample edges are at %f %f microns\n',x(ind(1)),x(ind(2)))
    

%     
%     figure(3);
%     plotting.smart_figure(3); 
%     imagesc(x,y,phasegrad)
%     axis xy equal tight
%     colormap bone
%     colorbar
%     hold on
%     plotting.vline(x(ind(1)),'-r')
%     plotting.vline(x(ind(2)),'-r')
%     hold off
%     title(filename)
%     
%     plotting.smart_figure(2);
%     plot(lineplot)
    
    pause(20)
end