% function tomo.check_rotation_0vs180(stack_object,theta,par)

function check_rotation_0vs180(stack_object,theta,par)

proj = stack_object(:,:,[find(theta==min(theta),1,'first') find(theta==max(theta),1,'last')]);

asize = par.asize;
proj = proj(round(asize(1)/2):end-round(asize(1)/2),round(asize(2)/2):end-round(asize(2)/2),:);
proj(:,:,2) = fliplr(proj(:,:,2));

phase_unwrap=math.unwrap2D_fft2(proj,[] ,0,[],0);
phase_unwrap_orig = phase_unwrap;
rotangle = [-0.2:0.02:0.2];
errdiff = rotangle*0;
for ii = 1:numel(rotangle)
    phase_unwrap(:,:,1) = imrotate(phase_unwrap_orig(:,:,1),rotangle(ii),'bicubic','crop');
    phase_unwrap(:,:,2) = imrotate(phase_unwrap_orig(:,:,2),-rotangle(ii),'bicubic','crop');
    shift = utils.find_shift_fast_2D(phase_unwrap, phase_unwrap(:,:,1), 0.1);
    phase_unwrap = utils.imshift_fft(phase_unwrap, -shift);
    extracrop = 4*round(max(size(stack_object))*sind(max(rotangle)));
    errordiff = diff(phase_unwrap(1+extracrop:end-extracrop,1+extracrop:end-extracrop,:),1,3);
    errdiff(ii) = sum(abs(errordiff(:)).^2);
    
%     figure(1); clf; plotting.imagesc3D(proj); axis xy equal tight
%     figure(2); clf; plotting.imagesc3D(phase_unwrap); colormap bone; axis xy equal tight;
%     figure(3); clf; plotting.imagesc3D(errordiff); colormap bone; axis xy equal tight;
end
    figh = figure(2); clf; plot(rotangle,errdiff,'-o');
    figh.Position = [136 727 1200 495];
    title('Error vs image rotation angle, comparing projections with smallest and largest theta (tomography angle)')
    xlabel('Image rotation [degrees]')


end

