/**
 * @file help.h
 * @author CXS group
 * @brief 
 * @version 0.1
 * @date 2019-07-22
 * 
 * *-----------------------------------------------------------------------*
 * |                                                                       |
 * |  Except where otherwise noted, this work is licensed under a          |
 * |  Creative Commons Attribution-NonCommercial-ShareAlike 4.0            |
 * |  International (CC BY-NC-SA 4.0) license.                             |
 * |                                                                       |
 * |  Copyright (c) 2017 by Paul Scherrer Institute (http://www.psi.ch)    |
 * |                                                                       |
 * |       Author: CXS group, PSI                                          |
 * *-----------------------------------------------------------------------*
 * You may use this code with the following provisions:
 *                                                                            
 * If the code is fully or partially redistributed, or rewritten in another
 *   computing language this notice should be included in the redistribution.
 * 
 * If this code, or subfunctions or parts of it, is used for research in a 
 *   publication or if it is fully or partially rewritten for another 
 *   computing language the authors and institution should be acknowledged 
 *  in written form in the publication: “Data processing was carried out 
 *   using the 'cSAXS software package' developed by the CXS group,
 *   Paul Scherrer Institut, Switzerland.”
 *   Variations on the latter text can be incorporated upon discussion with
 *   the CXS group if needed to more specifically reflect the use of the package
 *   for the published work.
 * 
 * A publication that focuses on describing features, or parameters, that
 *    are already existing in the code should be first discussed with the
 *    authors.
 *  
 * This code and subroutines are part of a continuous development, they 
 *    are provided “as they are” without guarantees or liability on part
 *    of PSI or the authors. It is the user responsibility to ensure its 
 *    proper use and the correctness of the results.
 * 
 */
#include "precomp.h"
#include "spec_reader_utils.h"

extern std::experimental::filesystem::path binaryName;

#ifndef HELP_H
#define HELP_H
struct globalArgs_t {
	std::string source;     /* -s option */
	std::string output;	/* -o option */
	int verbosity;		/* -v option */
	std::vector<int> scanNr;		/* --scanNr option */
	bool hdf5=false;	/* --hdf5 option */
	std::string orchestra;	/* --hdf5 option */
	std::string xmlLayoutFile;	/* --xmlLayout option */
	std::string datFiles;	/* --xmlLayout option */

};
#endif /* HELP_H */

void display_usage( void);

globalArgs_t ProcessArgs(int argc, char** argv);
