/* cbf_uncompress.c: 
 
   Compilation from Matlab:
   mex cbf_uncompress.c
   maybe a tiny bit faster code is generated by 
   mex -O COPTIMFLAGS='-O2' LDOPTIMFLAGS='-O2' cbf_uncompress.c
 
   Usage from Matlab:
   [frame] = ...
       cbf_uncompress(dat_in,dim1,dim2,no_of_in_bytes,compression_type);
 
   history:
   April 24th 2008: 
   1st version based on code snippet from Eric Eikenberry

*-----------------------------------------------------------------------*
|                                                                       |
|  Except where otherwise noted, this work is licensed under a          |
|  Creative Commons Attribution-NonCommercial-ShareAlike 4.0            |
|  International (CC BY-NC-SA 4.0) license.                             |
|                                                                       |
|  Copyright (c) 2017 by Paul Scherrer Institute (http://www.psi.ch)    |
|                                                                       |
|       Author: CXS group, PSI                                          |
*-----------------------------------------------------------------------*
 You may use this code with the following provisions:

 If the code is fully or partially redistributed, or rewritten in another
   computing language this notice should be included in the redistribution.

 If this code, or subfunctions or parts of it, is used for research in a 
   publication or if it is fully or partially rewritten for another 
   computing language the authors and institution should be acknowledged 
   in written form in the publication: “Data processing was carried out 
   using the “cSAXS software package” developed by the CXS group,
   Paul Scherrer Institut, Switzerland.” 
   Variations on the latter text can be incorporated upon discussion with 
   the CXS group if needed to more specifically reflect the use of the package 
   for the published work.

 A publication that focuses on describing features, or parameters, that
    are already existing in the code should be first discussed with the
    authors.
   
 This code and subroutines are part of a continuous development, they 
    are provided “as they are” without guarantees or liability on part
    of PSI or the authors. It is the user responsibility to ensure its 
    proper use and the correctness of the results.
*/

#include "mex.h"

#include <math.h> 
#include <stdio.h>

void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{
  const mxArray *curr_arg;
  union { 
    unsigned char *uint8;
             char *int8;
	unsigned short *uint16;
	         short *int16;
	unsigned int *uint32;
	         int *int32;
  } data_in,data_in_start;

  int dim1, dim2, no_of_in_bytes, compression_type;
  int diff, val_curr;
  double *frame_out, *frame_out_start;
  
    /* initialize return argument*/
  plhs[0] = NULL;
  
    /* Check for proper number of arguments. */
  if (nrhs != 5) 
    mexErrMsgTxt("Five input arguments required: dat_in,dim1,dim2,no_of_in_bytes,compression_type.");
  else if (nlhs != 1) 
    mexErrMsgTxt("One output argument has to be specified.");

  {
    int ind;
    for (ind = 0; ind < nrhs; ind++) {
      if(mxGetNumberOfDimensions(prhs[ind]) != 2) {
        printf("The %d. input argument must have two dimensions.",ind+1);
        mexErrMsgTxt("wrong number of dimensions");
      }
    }
  }
  
    /* check 1st input argument: input data */
  curr_arg = prhs[0];
  if (mxIsUint8(curr_arg) != 1)
    mexErrMsgTxt("Input 1 (input data) must be of type uint8.");
  data_in_start.uint8 = data_in.uint8 = (char *) mxGetPr(curr_arg);

    /* check 2nd input argument: dim1 */
  curr_arg = prhs[1];
  if (mxIsDouble(curr_arg) != 1)
    mexErrMsgTxt("Input 2 (dimension 1) must be of type double.");
  dim1 = mxGetScalar(curr_arg);
  if (dim1 < 1) {
    mexErrMsgTxt("Input 2 (dimension 1) must be at least 1.");
  }

    /* check 3rd input argument: dim2 */
  curr_arg = prhs[2];
  if (mxIsDouble(curr_arg) != 1)
    mexErrMsgTxt("Input 3 (dimension 2) must be of type double.");
  dim2 = mxGetScalar(curr_arg);
  if (dim2 < 1) {
    mexErrMsgTxt("Input 3 (dimension 2) must be at least 1.");
  }
  
    /* check 4th input argument: no_of_in_bytes */
  curr_arg = prhs[3];
  if (mxIsDouble(curr_arg) != 1)
    mexErrMsgTxt("Input 4 (no. of input bytes) must be of type double.");
  no_of_in_bytes = mxGetScalar(curr_arg);
  
    /* check 5th input argument: compression_type */
  curr_arg = prhs[4];
  if (mxIsDouble(curr_arg) != 1)
    mexErrMsgTxt("Input 5 (compression type) must be of type double.");
  compression_type = mxGetScalar(curr_arg);
  if (compression_type != 1) {
    mexErrMsgTxt("currently only compression type 1, byte-offset compression, is supported");
  }
  
    /* allocate memory for the output data */
  plhs[0] = mxCreateNumericMatrix(dim1, dim2, mxDOUBLE_CLASS, mxREAL);
  if (plhs[0] == NULL)
    mexErrMsgTxt("Could not allocate memory for return data.");
  frame_out_start = frame_out = mxGetPr(plhs[0]);

  val_curr = 0;
  while (data_in.uint8-data_in_start.uint8 < no_of_in_bytes) {
	if (*data_in.uint8 != 0x80) {
	  diff = (int) *data_in.int8++;
    } else {
  	  data_in.uint8++;
	  if (*data_in.uint16 != 0x8000) {
		diff = (int) *data_in.int16++;
      } else {
        data_in.uint16++;
		diff = (int) *data_in.int32++;
  	  }
    }
	val_curr += diff;
    *frame_out++ = (double) val_curr;
  }

  if (frame_out-frame_out_start != dim1*dim2) {
    printf("%ld bytes after uncompression, %ld bytes expected",
           frame_out-frame_out_start, dim1*dim2);
    mexErrMsgTxt("mismatch in number of extracted data bytes");
  }
  
  return;
}
